package servercore.http;

import java.util.HashMap;
import servercore.data.HtmlParam;

public class HttpRequest {
	public enum METHOD{
		GET,
		POST,
		HEAD,
		PUT,
		DELETE,
		OPTION,
		TRACE,
		CONNECT
	}
	private String extension = null;
	private METHOD reqest_method = null;
	private String request_path = null;
	private String real_path = null;
	private HashMap<String, String> headerMap = new HashMap<String, String>();
	private HtmlParam getParams = null;
	private HtmlParam postParams = null;
	private HashMap<String, String> cookieValues = new HashMap<String, String>();
	public byte[] headerBytes = null;
	public String getExtesion() {
		return extension;
	}
	public void setRequestMethod(METHOD method) {
		reqest_method = method;
	}
	public void setRequestMethod(String method) {
		if("GET".equals(method)) {
			reqest_method = METHOD.GET;
		} else if("POST".equals(method)) {
			reqest_method = METHOD.POST;
		} else if("PUT".equals(method)) {
			reqest_method = METHOD.PUT;
		} else if("DELETE".equals(method)) {
			reqest_method = METHOD.DELETE;
		} else if("HEAD".equals(method)) {
			reqest_method = METHOD.HEAD;
		} else if("OPTION".equals(method)) {
			reqest_method = METHOD.OPTION;
		} else if("TRACE".equals(method)) {
			reqest_method = METHOD.TRACE;
		} else if("CONNECT".equals(method)) {
			reqest_method = METHOD.CONNECT;
		}
	}
	public METHOD getMethod() {
		return this.reqest_method;
	}
	public void setPath(String path) {
		int index = path.indexOf('?');
		if(index > 0) {
			String[] uri = path.split("\\?");
			this.request_path = uri[0];
			getParams = HtmlParam.analyze(uri[1]);
		} else {
			this.request_path = path;
		}
	}
	public String getPath() {
		return real_path;
	}
	public String getRowPath() {
		return request_path;
	}
	public void normarizePath(String rootPath) {
		real_path = request_path;
		real_path = real_path.replaceAll("\\.\\.\\/", "");
		real_path = real_path.replaceAll("^\\/", rootPath + "/");
		real_path = real_path.replaceAll("/$", "/index.html");

		int index = real_path.lastIndexOf(".");
		String ext = "";
		if(index >= 0) {
			ext = real_path.substring(index + 1, real_path.length());
		}
		extension = ext;
	}
	public void setGetParams(HtmlParam param) {
		this.getParams = param;
	}
	public HtmlParam getGetParams() {
		return this.getParams;
	}
	public void setPostParams(HtmlParam param) {
		this.postParams = param;
	}
	public HtmlParam getPostParams() {
		return this.postParams;
	}
	public void setHeader(HashMap<String, String> map) {
		this.headerMap = map;
	}
	public HashMap<String, String> getHeader() {
		return this.headerMap;
	}
	public void setCookieValues(HashMap<String, String> map) {
		this.cookieValues = map;
	}
	public HashMap<String, String> getCookieValues() {
		return this.cookieValues;
	}
}
